/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.api.CompatModule;
import net.mehvahdjukaar.every_compat.api.EveryCompatAPI;
import net.mehvahdjukaar.every_compat.configs.EarlyConfigs;
import net.mehvahdjukaar.every_compat.configs.WoodConfigs;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.misc.AllWoodItem;
import net.mehvahdjukaar.moonlight.api.client.TextureCache;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.minecraft.class_1299;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class EveryCompat {
    public static final String MOD_ID = "everycomp";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Map<String, CompatModule> ACTIVE_MODULES = new LinkedHashMap<String, CompatModule>();
    public static final List<CompatMod> COMPAT_MODS = new ArrayList<CompatMod>();
    public static final Map<Class<? extends BlockType>, Set<String>> ENTRY_TYPES = new HashMap<Class<? extends BlockType>, Set<String>>();
    public static class_1761 MOD_TAB = null;
    public static final Supplier<AllWoodItem> ALL_WOODS = RegHelper.registerItem((class_2960)EveryCompat.res("all_woods"), AllWoodItem::new);
    private int prevRegSize;

    public static class_2960 res(String name) {
        return new class_2960(MOD_ID, name);
    }

    public static void forAllModules(Consumer<CompatModule> action) {
        ACTIVE_MODULES.values().forEach(action);
    }

    protected void commonInit() {
        EarlyConfigs.init();
        ServerDynamicResourcesHandler.INSTANCE.register();
        if (PlatformHelper.getEnv().isClient()) {
            ClientDynamicResourcesHandler.INSTANCE.register();
            TextureCache.registerSpecialTextureForBlock((class_1935)class_2246.field_10029, (String)"cactus_log_side", (class_2960)EveryCompat.res("block/cactus_side"));
            TextureCache.registerSpecialTextureForBlock((class_1935)class_2246.field_10029, (String)"cactus_log_top", (class_2960)EveryCompat.res("block/cactus_top"));
            TextureCache.registerSpecialTextureForBlock((class_1935)class_2246.field_10029, (String)"stripped_cactus_log_side", (class_2960)EveryCompat.res("block/stripped_cactus_side"));
            TextureCache.registerSpecialTextureForBlock((class_1935)class_2246.field_10029, (String)"stripped_cactus_log_top", (class_2960)EveryCompat.res("block/stripped_cactus_top"));
        }
        this.addOtherCompatMod("compatoplenty", "biomesoplenty", List.of("twigs", "farmersdelight", "quark", "woodworks"));
        this.addOtherCompatMod("compat_makeover", "biomemakeover", List.of("habitat", "farmersdelight", "quark", "decorative_blocks"));
        this.addOtherCompatMod("decorative_compat", "biomesoplenty", List.of("decorative_blocks"));
        this.addOtherCompatMod("macawsbridgesbop", "biomesoplenty", List.of("mcwbridges"));
        this.addOtherCompatMod("macawbridgesbyg", "byg", List.of("mcwbridges"));
        this.addOtherCompatMod("mcwfencesbop", "biomesoplenty", List.of("mcwfences"));
        this.addOtherCompatMod("mcwfencesbyg", "byg", List.of("mcwfences"));
        this.addOtherCompatMod("macawsroofsbop", "biomesoplenty", List.of("mcwroofs"));
        this.addOtherCompatMod("macawsroofsbyg", "byg", List.of("mcwroofs"));
        this.addOtherCompatMod("storagedrawersunlimited", "biomesoplenty", List.of("storagedrawers"));
        this.addOtherCompatMod("abnormals_delight", "atmospheric", List.of("farmersdelight"));
        this.addOtherCompatMod("abnormals_delight", "autumnity", List.of("farmersdelight"));
        this.addOtherCompatMod("abnormals_delight", "endergetic", List.of("farmersdelight"));
        this.addOtherCompatMod("abnormals_delight", "environmental", List.of("farmersdelight"));
        this.addOtherCompatMod("abnormals_delight", "upgrade_aquatic", List.of("farmersdelight"));
        EveryCompat.forAllModules(m -> LOGGER.info("Loaded {}", (Object)m.toString()));
        BlockSetAPI.addDynamicBlockRegistration(this::registerWoodStuff, WoodType.class);
        BlockSetAPI.addDynamicBlockRegistration(this::registerLeavesStuff, LeavesType.class);
        BlockSetAPI.addDynamicRegistration((r, c) -> this.registerItems((Registrator<class_1792>)r), WoodType.class, (class_2378)class_2378.field_11142);
        BlockSetAPI.addDynamicRegistration((r, c) -> this.registerTiles(r), WoodType.class, (class_2378)class_2378.field_11137);
        BlockSetAPI.addDynamicRegistration((r, c) -> this.registerEntities(r), WoodType.class, (class_2378)class_2378.field_11145);
    }

    public static <T extends BlockType> void addEntryType(Class<T> type, String childId) {
        ENTRY_TYPES.computeIfAbsent(type, t -> new HashSet()).add(childId);
    }

    private void addOtherCompatMod(String modId, String woodFrom, List<String> blocksFrom) {
        COMPAT_MODS.add(new CompatMod(modId, woodFrom, blocksFrom));
    }

    protected void addModule(String modId, Supplier<Function<String, CompatModule>> moduleFactory) {
        if (PlatformHelper.isModLoaded((String)modId)) {
            CompatModule module = moduleFactory.get().apply(modId);
            EveryCompatAPI.registerModule(module);
        }
    }

    private void addTab() {
        MOD_TAB = PlatformHelper.createModTab((class_2960)EveryCompat.res(MOD_ID), () -> ALL_WOODS.get().method_7854(), (boolean)true).method_7753("item_search.png");
    }

    public void commonSetup() {
        EveryCompat.forAllModules(CompatModule::onModSetup);
    }

    public void registerWoodStuff(Registrator<class_2248> event, Collection<WoodType> woods) {
        WoodConfigs.init();
        if (EarlyConfigs.TAB_ENABLED.get().booleanValue()) {
            this.addTab();
        }
        this.prevRegSize = class_2378.field_11146.method_10204();
        LOGGER.info("Registering Compat Wood Blocks");
        EveryCompat.forAllModules(m -> m.registerWoodBlocks(event, woods));
    }

    public void registerLeavesStuff(Registrator<class_2248> event, Collection<LeavesType> leaves) {
        LOGGER.info("Registering Compat Leaves Blocks");
        EveryCompat.forAllModules(m -> m.registerLeavesBlocks(event, leaves));
        int newSize = class_2378.field_11146.method_10204();
        int am = newSize - this.prevRegSize;
        float p = (float)am / (float)newSize * 100.0f;
        LOGGER.info("Registered {} compat blocks making up {}% of total blocks registered", (Object)am, (Object)Float.valueOf(p));
    }

    protected void registerItems(Registrator<class_1792> event) {
        EveryCompat.forAllModules(m -> m.registerItems(event));
    }

    protected void registerTiles(Registrator<class_2591<?>> event) {
        EveryCompat.forAllModules(m -> m.registerTiles(event));
    }

    protected void registerEntities(Registrator<class_1299<?>> event) {
        EveryCompat.forAllModules(m -> m.registerEntities(event));
    }

    public record CompatMod(String modId, String woodFrom, List<String> blocksFrom) {
    }
}

